/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.internal.ServerNotifForwarder;
import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.security.SubjectDelegator;
import com.sun.jmx.remote.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import com.sun.jmx.remote.util.OrderClassLoaders;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.UnmarshalException;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import sun.reflect.misc.ReflectUtil;

public class RMIConnectionImpl
implements RMIConnection,
Unreferenced {
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final String[] NO_STRINGS = new String[0];
    private final Subject subject;
    private final SubjectDelegator subjectDelegator;
    private final boolean removeCallerContext;
    private final AccessControlContext acc;
    private final RMIServerImpl rmiServer;
    private final MBeanServer mbeanServer;
    private final ClassLoader defaultClassLoader;
    private final ClassLoader defaultContextClassLoader;
    private final ClassLoaderWithRepository classLoaderWithRepository;
    private boolean terminated = false;
    private final String connectionId;
    private final ServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final int ADD_NOTIFICATION_LISTENERS = 1;
    private static final int ADD_NOTIFICATION_LISTENER_OBJECTNAME = 2;
    private static final int CREATE_MBEAN = 3;
    private static final int CREATE_MBEAN_PARAMS = 4;
    private static final int CREATE_MBEAN_LOADER = 5;
    private static final int CREATE_MBEAN_LOADER_PARAMS = 6;
    private static final int GET_ATTRIBUTE = 7;
    private static final int GET_ATTRIBUTES = 8;
    private static final int GET_DEFAULT_DOMAIN = 9;
    private static final int GET_DOMAINS = 10;
    private static final int GET_MBEAN_COUNT = 11;
    private static final int GET_MBEAN_INFO = 12;
    private static final int GET_OBJECT_INSTANCE = 13;
    private static final int INVOKE = 14;
    private static final int IS_INSTANCE_OF = 15;
    private static final int IS_REGISTERED = 16;
    private static final int QUERY_MBEANS = 17;
    private static final int QUERY_NAMES = 18;
    private static final int REMOVE_NOTIFICATION_LISTENER = 19;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME = 20;
    private static final int REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK = 21;
    private static final int SET_ATTRIBUTE = 22;
    private static final int SET_ATTRIBUTES = 23;
    private static final int UNREGISTER_MBEAN = 24;
    private ServerNotifForwarder serverNotifForwarder;
    private Map<String, ?> env;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectionImpl");

    public RMIConnectionImpl(RMIServerImpl rMIServerImpl, String string, ClassLoader classLoader, Subject subject, Map<String, ?> map) {
        if (rMIServerImpl == null || string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        if (map == null) {
            map = Collections.emptyMap();
        }
        this.rmiServer = rMIServerImpl;
        this.connectionId = string;
        this.defaultClassLoader = classLoader;
        this.subjectDelegator = new SubjectDelegator();
        this.subject = subject;
        if (subject == null) {
            this.acc = null;
            this.removeCallerContext = false;
        } else {
            this.removeCallerContext = SubjectDelegator.checkRemoveCallerContext(subject);
            this.acc = this.removeCallerContext ? JMXSubjectDomainCombiner.getDomainCombinerContext(subject) : JMXSubjectDomainCombiner.getContext(subject);
        }
        this.mbeanServer = rMIServerImpl.getMBeanServer();
        final ClassLoader classLoader2 = classLoader;
        final ClassLoaderRepository classLoaderRepository = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderRepository>(){

            @Override
            public ClassLoaderRepository run() {
                return RMIConnectionImpl.this.mbeanServer.getClassLoaderRepository();
            }
        }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoaderRepository")));
        this.classLoaderWithRepository = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderWithRepository>(){

            @Override
            public ClassLoaderWithRepository run() {
                return new ClassLoaderWithRepository(classLoaderRepository, classLoader2);
            }
        }, RMIConnectionImpl.withPermissions(new RuntimePermission("createClassLoader")));
        this.defaultContextClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new CombinedClassLoader(Thread.currentThread().getContextClassLoader(), classLoader2);
            }
        });
        this.serverCommunicatorAdmin = new RMIServerCommunicatorAdmin(EnvHelp.getServerConnectionTimeout(map));
        this.env = map;
    }

    private static AccessControlContext withPermissions(Permission ... permissionArray) {
        Permissions permissions = new Permissions();
        for (Permission permission : permissionArray) {
            permissions.add(permission);
        }
        ProtectionDomain protectionDomain = new ProtectionDomain(null, permissions);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    private synchronized ServerNotifForwarder getServerNotifFwd() {
        if (this.serverNotifForwarder == null) {
            this.serverNotifForwarder = new ServerNotifForwarder(this.mbeanServer, this.env, this.rmiServer.getNotifBuffer(), this.connectionId);
        }
        return this.serverNotifForwarder;
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean bl = logger.debugOn();
        String string = bl ? "[" + this.toString() + "]" : null;
        RMIConnectionImpl rMIConnectionImpl = this;
        synchronized (rMIConnectionImpl) {
            if (this.terminated) {
                if (bl) {
                    logger.debug("close", string + " already terminated.");
                }
                return;
            }
            if (bl) {
                logger.debug("close", string + " closing.");
            }
            this.terminated = true;
            if (this.serverCommunicatorAdmin != null) {
                this.serverCommunicatorAdmin.terminate();
            }
            if (this.serverNotifForwarder != null) {
                this.serverNotifForwarder.terminate();
            }
        }
        this.rmiServer.clientClosed(this);
        if (bl) {
            logger.debug("close", string + " closed.");
        }
    }

    @Override
    public void unreferenced() {
        logger.debug("unreferenced", "called");
        try {
            this.close();
            logger.debug("unreferenced", "done");
        }
        catch (IOException iOException) {
            logger.fine("unreferenced", iOException);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            Object[] objectArray = new Object[]{string, objectName};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName)", "connectionId=" + this.connectionId + ", className=" + string + ", name=" + objectName);
            }
            return (ObjectInstance)this.doPrivilegedOperation(3, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            Object[] objectArray = new Object[]{string, objectName, objectName2};
            if (logger.debugOn()) {
                logger.debug("createMBean(String,ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", className=" + string + ", name=" + objectName + ", loaderName=" + objectName2);
            }
            return (ObjectInstance)this.doPrivilegedOperation(5, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, MarshalledObject marshalledObject, String[] stringArray, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping parameters using classLoaderWithRepository.");
        }
        Object[] objectArray = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(marshalledObject, this.classLoaderWithRepository, Object[].class));
        try {
            Object[] objectArray2 = new Object[]{string, objectName, objectArray, RMIConnectionImpl.nullIsEmpty(stringArray)};
            if (bl) {
                logger.debug("createMBean(String,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + string + ", name=" + objectName + ", signature=" + RMIConnectionImpl.strings(stringArray));
            }
            return (ObjectInstance)this.doPrivilegedOperation(4, objectArray2, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, MarshalledObject marshalledObject, String[] stringArray, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", unwrapping params with MBean extended ClassLoader.");
        }
        Object[] objectArray = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(marshalledObject, this.getClassLoader(objectName2), this.defaultClassLoader, Object[].class));
        try {
            Object[] objectArray2 = new Object[]{string, objectName, objectName2, objectArray, RMIConnectionImpl.nullIsEmpty(stringArray)};
            if (bl) {
                logger.debug("createMBean(String,ObjectName,ObjectName,Object[],String[])", "connectionId=" + this.connectionId + ", className=" + string + ", name=" + objectName + ", loaderName=" + objectName2 + ", signature=" + RMIConnectionImpl.strings(stringArray));
            }
            return (ObjectInstance)this.doPrivilegedOperation(6, objectArray2, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public void unregisterMBean(ObjectName objectName, Subject subject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            Object[] objectArray = new Object[]{objectName};
            if (logger.debugOn()) {
                logger.debug("unregisterMBean", "connectionId=" + this.connectionId + ", name=" + objectName);
            }
            this.doPrivilegedOperation(24, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName, Subject subject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", objectName);
        try {
            Object[] objectArray = new Object[]{objectName};
            if (logger.debugOn()) {
                logger.debug("getObjectInstance", "connectionId=" + this.connectionId + ", name=" + objectName);
            }
            return (ObjectInstance)this.doPrivilegedOperation(13, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, MarshalledObject marshalledObject, Subject subject) throws IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("queryMBeans", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryExp = RMIConnectionImpl.unwrap(marshalledObject, this.defaultContextClassLoader, QueryExp.class);
        try {
            Object[] objectArray = new Object[]{objectName, queryExp};
            if (bl) {
                logger.debug("queryMBeans", "connectionId=" + this.connectionId + ", name=" + objectName + ", query=" + marshalledObject);
            }
            return (Set)Util.cast(this.doPrivilegedOperation(17, objectArray, subject));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, MarshalledObject marshalledObject, Subject subject) throws IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("queryNames", "connectionId=" + this.connectionId + " unwrapping query with defaultClassLoader.");
        }
        QueryExp queryExp = RMIConnectionImpl.unwrap(marshalledObject, this.defaultContextClassLoader, QueryExp.class);
        try {
            Object[] objectArray = new Object[]{objectName, queryExp};
            if (bl) {
                logger.debug("queryNames", "connectionId=" + this.connectionId + ", name=" + objectName + ", query=" + marshalledObject);
            }
            return (Set)Util.cast(this.doPrivilegedOperation(18, objectArray, subject));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName, Subject subject) throws IOException {
        try {
            Object[] objectArray = new Object[]{objectName};
            return (Boolean)this.doPrivilegedOperation(16, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Integer getMBeanCount(Subject subject) throws IOException {
        try {
            Object[] objectArray = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getMBeanCount", "connectionId=" + this.connectionId);
            }
            return (Integer)this.doPrivilegedOperation(11, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string, Subject subject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] objectArray = new Object[]{objectName, string};
            if (logger.debugOn()) {
                logger.debug("getAttribute", "connectionId=" + this.connectionId + ", name=" + objectName + ", attribute=" + string);
            }
            return this.doPrivilegedOperation(7, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray, Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            Object[] objectArray = new Object[]{objectName, stringArray};
            if (logger.debugOn()) {
                logger.debug("getAttributes", "connectionId=" + this.connectionId + ", name=" + objectName + ", attributes=" + RMIConnectionImpl.strings(stringArray));
            }
            return (AttributeList)this.doPrivilegedOperation(8, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, MarshalledObject marshalledObject, Subject subject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("setAttribute", "connectionId=" + this.connectionId + " unwrapping attribute with MBean extended ClassLoader.");
        }
        Attribute attribute = RMIConnectionImpl.unwrap(marshalledObject, this.getClassLoaderFor(objectName), this.defaultClassLoader, Attribute.class);
        try {
            Object[] objectArray = new Object[]{objectName, attribute};
            if (bl) {
                logger.debug("setAttribute", "connectionId=" + this.connectionId + ", name=" + objectName + ", attribute name=" + attribute.getName());
            }
            this.doPrivilegedOperation(22, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, MarshalledObject marshalledObject, Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("setAttributes", "connectionId=" + this.connectionId + " unwrapping attributes with MBean extended ClassLoader.");
        }
        AttributeList attributeList = RMIConnectionImpl.unwrap(marshalledObject, this.getClassLoaderFor(objectName), this.defaultClassLoader, AttributeList.class);
        try {
            Object[] objectArray = new Object[]{objectName, attributeList};
            if (bl) {
                logger.debug("setAttributes", "connectionId=" + this.connectionId + ", name=" + objectName + ", attribute names=" + RMIConnector.getAttributesNames(attributeList));
            }
            return (AttributeList)this.doPrivilegedOperation(23, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String string, MarshalledObject marshalledObject, String[] stringArray, Subject subject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", objectName);
        RMIConnectionImpl.checkNonNull("Operation name", string);
        boolean bl = logger.debugOn();
        if (bl) {
            logger.debug("invoke", "connectionId=" + this.connectionId + " unwrapping params with MBean extended ClassLoader.");
        }
        Object[] objectArray = RMIConnectionImpl.nullIsEmpty(RMIConnectionImpl.unwrap(marshalledObject, this.getClassLoaderFor(objectName), this.defaultClassLoader, Object[].class));
        try {
            Object[] objectArray2 = new Object[]{objectName, string, objectArray, RMIConnectionImpl.nullIsEmpty(stringArray)};
            if (bl) {
                logger.debug("invoke", "connectionId=" + this.connectionId + ", name=" + objectName + ", operationName=" + string + ", signature=" + RMIConnectionImpl.strings(stringArray));
            }
            return this.doPrivilegedOperation(14, objectArray2, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public String getDefaultDomain(Subject subject) throws IOException {
        try {
            Object[] objectArray = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDefaultDomain", "connectionId=" + this.connectionId);
            }
            return (String)this.doPrivilegedOperation(9, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public String[] getDomains(Subject subject) throws IOException {
        try {
            Object[] objectArray = new Object[]{};
            if (logger.debugOn()) {
                logger.debug("getDomains", "connectionId=" + this.connectionId);
            }
            return (String[])this.doPrivilegedOperation(10, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName, Subject subject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", objectName);
        try {
            Object[] objectArray = new Object[]{objectName};
            if (logger.debugOn()) {
                logger.debug("getMBeanInfo", "connectionId=" + this.connectionId + ", name=" + objectName);
            }
            return (MBeanInfo)this.doPrivilegedOperation(12, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IntrospectionException) {
                throw (IntrospectionException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string, Subject subject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("ObjectName", objectName);
        try {
            Object[] objectArray = new Object[]{objectName, string};
            if (logger.debugOn()) {
                logger.debug("isInstanceOf", "connectionId=" + this.connectionId + ", name=" + objectName + ", className=" + string);
            }
            return (Boolean)this.doPrivilegedOperation(15, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public Integer[] addNotificationListeners(ObjectName[] objectNameArray, MarshalledObject[] marshalledObjectArray, Subject[] subjectArray) throws InstanceNotFoundException, IOException {
        int n;
        Subject[] subjectArray2;
        if (objectNameArray == null || marshalledObjectArray == null) {
            throw new IllegalArgumentException("Got null arguments.");
        }
        Subject[] subjectArray3 = subjectArray2 = subjectArray != null ? subjectArray : new Subject[objectNameArray.length];
        if (objectNameArray.length != marshalledObjectArray.length || marshalledObjectArray.length != subjectArray2.length) {
            throw new IllegalArgumentException("The value lengths of 3 parameters are not same.");
        }
        for (n = 0; n < objectNameArray.length; ++n) {
            if (objectNameArray[n] != null) continue;
            throw new IllegalArgumentException("Null Object name.");
        }
        NotificationFilter[] notificationFilterArray = new NotificationFilter[objectNameArray.length];
        Integer[] integerArray = new Integer[objectNameArray.length];
        boolean bl = logger.debugOn();
        try {
            for (n = 0; n < objectNameArray.length; ++n) {
                ClassLoader classLoader = this.getClassLoaderFor(objectNameArray[n]);
                if (bl) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
                }
                notificationFilterArray[n] = RMIConnectionImpl.unwrap(marshalledObjectArray[n], classLoader, this.defaultClassLoader, NotificationFilter.class);
                if (bl) {
                    logger.debug("addNotificationListener(ObjectName,NotificationFilter)", "connectionId=" + this.connectionId + ", name=" + objectNameArray[n] + ", filter=" + notificationFilterArray[n]);
                }
                integerArray[n] = (Integer)this.doPrivilegedOperation(1, new Object[]{objectNameArray[n], notificationFilterArray[n]}, subjectArray2[n]);
            }
            return integerArray;
        }
        catch (Exception exception) {
            Exception exception2;
            for (int i = 0; i < n; ++i) {
                try {
                    this.getServerNotifFwd().removeNotificationListener(objectNameArray[i], integerArray[i]);
                    continue;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            if (exception instanceof PrivilegedActionException) {
                exception2 = RMIConnectionImpl.extractException(exception);
            }
            if (exception2 instanceof ClassCastException) {
                throw (ClassCastException)exception2;
            }
            if (exception2 instanceof IOException) {
                throw (IOException)exception2;
            }
            if (exception2 instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception2;
            }
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception2, exception2);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, MarshalledObject marshalledObject, MarshalledObject marshalledObject2, Subject subject) throws InstanceNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", objectName);
        RMIConnectionImpl.checkNonNull("Listener MBean name", objectName2);
        boolean bl = logger.debugOn();
        ClassLoader classLoader = this.getClassLoaderFor(objectName);
        if (bl) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter notificationFilter = RMIConnectionImpl.unwrap(marshalledObject, classLoader, this.defaultClassLoader, NotificationFilter.class);
        if (bl) {
            logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object object = RMIConnectionImpl.unwrap(marshalledObject2, classLoader, this.defaultClassLoader, Object.class);
        try {
            Object[] objectArray = new Object[]{objectName, objectName2, notificationFilter, object};
            if (bl) {
                logger.debug("addNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + objectName + ", listenerName=" + objectName2 + ", filter=" + notificationFilter + ", handback=" + object);
            }
            this.doPrivilegedOperation(2, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public void removeNotificationListeners(ObjectName objectName, Integer[] integerArray, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (objectName == null || integerArray == null) {
            throw new IllegalArgumentException("Illegal null parameter");
        }
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] != null) continue;
            throw new IllegalArgumentException("Null listener ID");
        }
        try {
            Object[] objectArray = new Object[]{objectName, integerArray};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,Integer[])", "connectionId=" + this.connectionId + ", name=" + objectName + ", listenerIDs=" + RMIConnectionImpl.objects(integerArray));
            }
            this.doPrivilegedOperation(19, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", objectName);
        RMIConnectionImpl.checkNonNull("Listener MBean name", objectName2);
        try {
            Object[] objectArray = new Object[]{objectName, objectName2};
            if (logger.debugOn()) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName)", "connectionId=" + this.connectionId + ", name=" + objectName + ", listenerName=" + objectName2);
            }
            this.doPrivilegedOperation(20, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, MarshalledObject marshalledObject, MarshalledObject marshalledObject2, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        RMIConnectionImpl.checkNonNull("Target MBean name", objectName);
        RMIConnectionImpl.checkNonNull("Listener MBean name", objectName2);
        boolean bl = logger.debugOn();
        ClassLoader classLoader = this.getClassLoaderFor(objectName);
        if (bl) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping filter with target extended ClassLoader.");
        }
        NotificationFilter notificationFilter = RMIConnectionImpl.unwrap(marshalledObject, classLoader, this.defaultClassLoader, NotificationFilter.class);
        if (bl) {
            logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + " unwrapping handback with target extended ClassLoader.");
        }
        Object object = RMIConnectionImpl.unwrap(marshalledObject2, classLoader, this.defaultClassLoader, Object.class);
        try {
            Object[] objectArray = new Object[]{objectName, objectName2, notificationFilter, object};
            if (bl) {
                logger.debug("removeNotificationListener(ObjectName,ObjectName,NotificationFilter,Object)", "connectionId=" + this.connectionId + ", name=" + objectName + ", listenerName=" + objectName2 + ", filter=" + notificationFilter + ", handback=" + object);
            }
            this.doPrivilegedOperation(21, objectArray, subject);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw RMIConnectionImpl.newIOException("Got unexpected server exception: " + exception, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationResult fetchNotifications(long l, int n, long l2) throws IOException {
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "connectionId=" + this.connectionId + ", timeout=" + l2);
        }
        if (n < 0 || l2 < 0L) {
            throw new IllegalArgumentException("Illegal negative argument");
        }
        boolean bl = this.serverCommunicatorAdmin.reqIncoming();
        try {
            if (bl) {
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "The notification server has been closed, returns null to force the client to stop fetching");
                }
                NotificationResult notificationResult = null;
                return notificationResult;
            }
            final long l3 = l;
            final int n2 = n;
            final long l4 = l2;
            PrivilegedAction<NotificationResult> privilegedAction = new PrivilegedAction<NotificationResult>(){

                @Override
                public NotificationResult run() {
                    return RMIConnectionImpl.this.getServerNotifFwd().fetchNotifs(l3, l4, n2);
                }
            };
            if (this.acc == null) {
                NotificationResult notificationResult = (NotificationResult)privilegedAction.run();
                return notificationResult;
            }
            NotificationResult notificationResult = AccessController.doPrivileged(privilegedAction, this.acc);
            return notificationResult;
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    public String toString() {
        return super.toString() + ": connectionId=" + this.connectionId;
    }

    private ClassLoader getClassLoader(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoader(objectName);
                }
            }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoader")));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(privilegedActionException);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException {
                    return RMIConnectionImpl.this.mbeanServer.getClassLoaderFor(objectName);
                }
            }, RMIConnectionImpl.withPermissions(new MBeanPermission("*", "getClassLoaderFor")));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)RMIConnectionImpl.extractException(privilegedActionException);
        }
    }

    private Object doPrivilegedOperation(int n, Object[] objectArray, Subject subject) throws PrivilegedActionException, IOException {
        this.serverCommunicatorAdmin.reqIncoming();
        try {
            AccessControlContext accessControlContext;
            if (subject == null) {
                accessControlContext = this.acc;
            } else {
                if (this.subject == null) {
                    throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                }
                accessControlContext = this.subjectDelegator.delegatedContext(this.acc, subject, this.removeCallerContext);
            }
            PrivilegedOperation privilegedOperation = new PrivilegedOperation(n, objectArray);
            if (accessControlContext == null) {
                try {
                    Object object = privilegedOperation.run();
                    return object;
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new PrivilegedActionException(exception);
                }
            }
            Object object = AccessController.doPrivileged(privilegedOperation, accessControlContext);
            return object;
        }
        catch (Error error) {
            throw new JMXServerErrorException(error.toString(), error);
        }
        finally {
            this.serverCommunicatorAdmin.rspOutgoing();
        }
    }

    private Object doOperation(int n, Object[] objectArray) throws Exception {
        switch (n) {
            case 3: {
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1]);
            }
            case 5: {
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2]);
            }
            case 4: {
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
            }
            case 6: {
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2], (Object[])objectArray[3], (String[])objectArray[4]);
            }
            case 7: {
                return this.mbeanServer.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            case 8: {
                return this.mbeanServer.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
            }
            case 9: {
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                return this.mbeanServer.getDomains();
            }
            case 11: {
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                return this.mbeanServer.getMBeanInfo((ObjectName)objectArray[0]);
            }
            case 13: {
                return this.mbeanServer.getObjectInstance((ObjectName)objectArray[0]);
            }
            case 14: {
                return this.mbeanServer.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
            }
            case 15: {
                return this.mbeanServer.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.mbeanServer.isRegistered((ObjectName)objectArray[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.mbeanServer.queryMBeans((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
            }
            case 18: {
                return this.mbeanServer.queryNames((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
            }
            case 22: {
                this.mbeanServer.setAttribute((ObjectName)objectArray[0], (Attribute)objectArray[1]);
                return null;
            }
            case 23: {
                return this.mbeanServer.setAttributes((ObjectName)objectArray[0], (AttributeList)objectArray[1]);
            }
            case 24: {
                this.mbeanServer.unregisterMBean((ObjectName)objectArray[0]);
                return null;
            }
            case 1: {
                return this.getServerNotifFwd().addNotificationListener((ObjectName)objectArray[0], (NotificationFilter)objectArray[1]);
            }
            case 2: {
                this.mbeanServer.addNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2], objectArray[3]);
                return null;
            }
            case 19: {
                this.getServerNotifFwd().removeNotificationListener((ObjectName)objectArray[0], (Integer[])objectArray[1]);
                return null;
            }
            case 20: {
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1]);
                return null;
            }
            case 21: {
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2], objectArray[3]);
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid operation");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T unwrap(MarshalledObject<?> marshalledObject, ClassLoader classLoader, Class<T> clazz) throws IOException {
        if (marshalledObject == null) {
            return null;
        }
        try {
            ClassLoader classLoader2 = AccessController.doPrivileged(new SetCcl(classLoader));
            try {
                T t = clazz.cast(marshalledObject.get());
                return t;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnmarshalException(classNotFoundException.toString(), classNotFoundException);
            }
            finally {
                AccessController.doPrivileged(new SetCcl(classLoader2));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw new UnmarshalException(exception.toString(), exception);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + exception);
            logger.debug("unwrap", exception);
            return null;
        }
    }

    private static <T> T unwrap(MarshalledObject<?> marshalledObject, final ClassLoader classLoader, final ClassLoader classLoader2, Class<T> clazz) throws IOException {
        if (marshalledObject == null) {
            return null;
        }
        try {
            ClassLoader classLoader3 = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                @Override
                public ClassLoader run() throws Exception {
                    return new CombinedClassLoader(Thread.currentThread().getContextClassLoader(), new OrderClassLoaders(classLoader, classLoader2));
                }
            });
            return RMIConnectionImpl.unwrap(marshalledObject, classLoader3, clazz);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = RMIConnectionImpl.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw new UnmarshalException(exception.toString(), exception);
            }
            logger.warning("unwrap", "Failed to unmarshall object: " + exception);
            logger.debug("unwrap", exception);
            return null;
        }
    }

    private static IOException newIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        return EnvHelp.initCause(iOException, throwable);
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    private static Object[] nullIsEmpty(Object[] objectArray) {
        return objectArray == null ? NO_OBJECTS : objectArray;
    }

    private static String[] nullIsEmpty(String[] stringArray) {
        return stringArray == null ? NO_STRINGS : stringArray;
    }

    private static void checkNonNull(String string, Object object) {
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string + " must not be null");
            throw new RuntimeOperationsException(illegalArgumentException);
        }
    }

    private static String objects(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        return Arrays.asList(objectArray).toString();
    }

    private static String strings(String[] stringArray) {
        return RMIConnectionImpl.objects(stringArray);
    }

    private static final class CombinedClassLoader
    extends ClassLoader {
        final ClassLoaderWrapper defaultCL;

        private CombinedClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
            super(classLoader);
            this.defaultCL = new ClassLoaderWrapper(classLoader2);
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            ReflectUtil.checkPackageAccess(string);
            try {
                super.loadClass(string, bl);
            }
            catch (Exception exception) {
                for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                    if (!(throwable instanceof SecurityException)) continue;
                    throw throwable == exception ? (SecurityException)throwable : new SecurityException(throwable.getMessage(), exception);
                }
            }
            Class<?> clazz = this.defaultCL.loadClass(string, bl);
            return clazz;
        }

        private static final class ClassLoaderWrapper
        extends ClassLoader {
            ClassLoaderWrapper(ClassLoader classLoader) {
                super(classLoader);
            }

            @Override
            protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
                return super.loadClass(string, bl);
            }
        }
    }

    private class PrivilegedOperation
    implements PrivilegedExceptionAction<Object> {
        private int operation;
        private Object[] params;

        public PrivilegedOperation(int n, Object[] objectArray) {
            this.operation = n;
            this.params = objectArray;
        }

        @Override
        public Object run() throws Exception {
            return RMIConnectionImpl.this.doOperation(this.operation, this.params);
        }
    }

    private class RMIServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public RMIServerCommunicatorAdmin(long l) {
            super(l);
        }

        @Override
        protected void doStop() {
            try {
                RMIConnectionImpl.this.close();
            }
            catch (IOException iOException) {
                logger.warning("RMIServerCommunicatorAdmin-doStop", "Failed to close: " + iOException);
                logger.debug("RMIServerCommunicatorAdmin-doStop", iOException);
            }
        }
    }

    private static class SetCcl
    implements PrivilegedExceptionAction<ClassLoader> {
        private final ClassLoader classLoader;

        SetCcl(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(this.classLoader);
            return classLoader;
        }
    }
}

