/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sun.security.util.KeyUtil;

final class SignatureAndHashAlgorithm {
    static final int SUPPORTED_ALG_PRIORITY_MAX_NUM = 240;
    private static final Set<CryptoPrimitive> SIGNATURE_PRIMITIVE_SET = Collections.unmodifiableSet(EnumSet.of(CryptoPrimitive.SIGNATURE));
    private static final Map<Integer, SignatureAndHashAlgorithm> supportedMap = Collections.synchronizedSortedMap(new TreeMap());
    private static final Map<Integer, SignatureAndHashAlgorithm> priorityMap = Collections.synchronizedSortedMap(new TreeMap());
    private HashAlgorithm hash;
    private int id;
    private String algorithm;
    private int priority;

    private SignatureAndHashAlgorithm(HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string, int n) {
        this.hash = hashAlgorithm;
        this.algorithm = string;
        this.id = (hashAlgorithm.value & 0xFF) << 8 | signatureAlgorithm.value & 0xFF;
        this.priority = n;
    }

    private SignatureAndHashAlgorithm(String string, int n, int n2) {
        this.hash = HashAlgorithm.valueOf(n >> 8 & 0xFF);
        this.algorithm = string;
        this.id = n;
        this.priority = 240 + n2 + 1;
    }

    static SignatureAndHashAlgorithm valueOf(int n, int n2, int n3) {
        int n4 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = supportedMap.get(n4);
        if (signatureAndHashAlgorithm == null) {
            signatureAndHashAlgorithm = new SignatureAndHashAlgorithm("Unknown (hash:0x" + Integer.toString(n, 16) + ", signature:0x" + Integer.toString(n2, 16) + ")", n4, n3);
        }
        return signatureAndHashAlgorithm;
    }

    int getHashValue() {
        return this.id >> 8 & 0xFF;
    }

    int getSignatureValue() {
        return this.id & 0xFF;
    }

    String getAlgorithmName() {
        return this.algorithm;
    }

    static int sizeInRecord() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(AlgorithmConstraints algorithmConstraints) {
        ArrayList<SignatureAndHashAlgorithm> arrayList = new ArrayList<SignatureAndHashAlgorithm>();
        Map<Integer, SignatureAndHashAlgorithm> map = priorityMap;
        synchronized (map) {
            for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : priorityMap.values()) {
                if (signatureAndHashAlgorithm.priority > 240 || !algorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, signatureAndHashAlgorithm.algorithm, null)) continue;
                arrayList.add(signatureAndHashAlgorithm);
            }
        }
        return arrayList;
    }

    static Collection<SignatureAndHashAlgorithm> getSupportedAlgorithms(AlgorithmConstraints algorithmConstraints, Collection<SignatureAndHashAlgorithm> collection) {
        ArrayList<SignatureAndHashAlgorithm> arrayList = new ArrayList<SignatureAndHashAlgorithm>();
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
            if (signatureAndHashAlgorithm.priority > 240 || !algorithmConstraints.permits(SIGNATURE_PRIMITIVE_SET, signatureAndHashAlgorithm.algorithm, null)) continue;
            arrayList.add(signatureAndHashAlgorithm);
        }
        return arrayList;
    }

    static String[] getAlgorithmNames(Collection<SignatureAndHashAlgorithm> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (collection != null) {
            for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
                arrayList.add(signatureAndHashAlgorithm.algorithm);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    static Set<String> getHashAlgorithmNames(Collection<SignatureAndHashAlgorithm> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        if (collection != null) {
            for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
                if (signatureAndHashAlgorithm.hash.value <= 0) continue;
                hashSet.add(signatureAndHashAlgorithm.hash.standardName);
            }
        }
        return hashSet;
    }

    static String getHashAlgorithmName(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        return signatureAndHashAlgorithm.hash.standardName;
    }

    private static void supports(HashAlgorithm hashAlgorithm, SignatureAlgorithm signatureAlgorithm, String string, int n) {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = new SignatureAndHashAlgorithm(hashAlgorithm, signatureAlgorithm, string, n);
        if (supportedMap.put(signatureAndHashAlgorithm.id, signatureAndHashAlgorithm) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, id: " + signatureAndHashAlgorithm.id);
        }
        if (priorityMap.put(signatureAndHashAlgorithm.priority, signatureAndHashAlgorithm) != null) {
            throw new RuntimeException("Duplicate SignatureAndHashAlgorithm definition, priority: " + signatureAndHashAlgorithm.priority);
        }
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> collection, String string) {
        return SignatureAndHashAlgorithm.getPreferableAlgorithm(collection, string, null);
    }

    static SignatureAndHashAlgorithm getPreferableAlgorithm(Collection<SignatureAndHashAlgorithm> collection, String string, PrivateKey privateKey) {
        int n = SignatureAndHashAlgorithm.getMaxDigestLength(privateKey);
        for (SignatureAndHashAlgorithm signatureAndHashAlgorithm : collection) {
            int n2 = signatureAndHashAlgorithm.id & 0xFF;
            if (!(string == null || string.equalsIgnoreCase("rsa") && n2 == SignatureAlgorithm.RSA.value || string.equalsIgnoreCase("dsa") && n2 == SignatureAlgorithm.DSA.value || string.equalsIgnoreCase("ecdsa") && n2 == SignatureAlgorithm.ECDSA.value) && (!string.equalsIgnoreCase("ec") || n2 != SignatureAlgorithm.ECDSA.value) || signatureAndHashAlgorithm.priority > 240 || signatureAndHashAlgorithm.hash.length > n) continue;
            return signatureAndHashAlgorithm;
        }
        return null;
    }

    private static int getMaxDigestLength(PrivateKey privateKey) {
        int n = Integer.MAX_VALUE;
        if (privateKey != null && "rsa".equalsIgnoreCase(privateKey.getAlgorithm())) {
            int n2 = KeyUtil.getKeySize(privateKey);
            if (n2 >= 768) {
                n = HashAlgorithm.SHA512.length;
            } else if (n2 >= 512 && n2 < 768) {
                n = HashAlgorithm.SHA256.length;
            } else if (n2 > 0 && n2 < 512) {
                n = HashAlgorithm.SHA1.length;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<Integer, SignatureAndHashAlgorithm> map = supportedMap;
        synchronized (map) {
            int n = 240;
            SignatureAndHashAlgorithm.supports(HashAlgorithm.MD5, SignatureAlgorithm.RSA, "MD5withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.DSA, "SHA1withDSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.RSA, "SHA1withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA1, SignatureAlgorithm.ECDSA, "SHA1withECDSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA224, SignatureAlgorithm.RSA, "SHA224withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA224, SignatureAlgorithm.ECDSA, "SHA224withECDSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA256, SignatureAlgorithm.RSA, "SHA256withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA256, SignatureAlgorithm.ECDSA, "SHA256withECDSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA384, SignatureAlgorithm.RSA, "SHA384withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA384, SignatureAlgorithm.ECDSA, "SHA384withECDSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA512, SignatureAlgorithm.RSA, "SHA512withRSA", --n);
            SignatureAndHashAlgorithm.supports(HashAlgorithm.SHA512, SignatureAlgorithm.ECDSA, "SHA512withECDSA", --n);
        }
    }

    static enum HashAlgorithm {
        UNDEFINED("undefined", "", -1, -1),
        NONE("none", "NONE", 0, -1),
        MD5("md5", "MD5", 1, 16),
        SHA1("sha1", "SHA-1", 2, 20),
        SHA224("sha224", "SHA-224", 3, 28),
        SHA256("sha256", "SHA-256", 4, 32),
        SHA384("sha384", "SHA-384", 5, 48),
        SHA512("sha512", "SHA-512", 6, 64);

        final String name;
        final String standardName;
        final int value;
        final int length;

        private HashAlgorithm(String string2, String string3, int n2, int n3) {
            this.name = string2;
            this.standardName = string3;
            this.value = n2;
            this.length = n3;
        }

        static HashAlgorithm valueOf(int n) {
            HashAlgorithm hashAlgorithm = UNDEFINED;
            switch (n) {
                case 0: {
                    hashAlgorithm = NONE;
                    break;
                }
                case 1: {
                    hashAlgorithm = MD5;
                    break;
                }
                case 2: {
                    hashAlgorithm = SHA1;
                    break;
                }
                case 3: {
                    hashAlgorithm = SHA224;
                    break;
                }
                case 4: {
                    hashAlgorithm = SHA256;
                    break;
                }
                case 5: {
                    hashAlgorithm = SHA384;
                    break;
                }
                case 6: {
                    hashAlgorithm = SHA512;
                }
            }
            return hashAlgorithm;
        }
    }

    static enum SignatureAlgorithm {
        UNDEFINED("undefined", -1),
        ANONYMOUS("anonymous", 0),
        RSA("rsa", 1),
        DSA("dsa", 2),
        ECDSA("ecdsa", 3);

        final String name;
        final int value;

        private SignatureAlgorithm(String string2, int n2) {
            this.name = string2;
            this.value = n2;
        }

        static SignatureAlgorithm valueOf(int n) {
            SignatureAlgorithm signatureAlgorithm = UNDEFINED;
            switch (n) {
                case 0: {
                    signatureAlgorithm = ANONYMOUS;
                    break;
                }
                case 1: {
                    signatureAlgorithm = RSA;
                    break;
                }
                case 2: {
                    signatureAlgorithm = DSA;
                    break;
                }
                case 3: {
                    signatureAlgorithm = ECDSA;
                }
            }
            return signatureAlgorithm;
        }
    }
}

