/*
 * Decompiled with CFR 0.152.
 */
package toolbar.save;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import toolbar.item.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarPersister {
    private static final String FILE_NAME = "toolbar.sav";
    private String folderName = "";

    public ToolbarPersister(String folderName) {
        this.folderName = folderName;
    }

    public void save(Vector<Item> lstItem) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(String.valueOf(this.folderName) + FILE_NAME));
            os.writeShort(lstItem.size());
            for (Item i : lstItem) {
                os.writeObject(i);
            }
            os.flush();
            os.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Vector<Item> load() {
        Vector<Item> lstItem = new Vector<Item>();
        if (new File(String.valueOf(this.folderName) + FILE_NAME).exists()) {
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(String.valueOf(this.folderName) + FILE_NAME));
                int nbItem = is.readUnsignedShort();
                int i = 0;
                while (i < nbItem) {
                    lstItem.add((Item)is.readObject());
                    ++i;
                }
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return lstItem;
    }
}

