/*
 * Decompiled with CFR 0.152.
 */
package toolbar.item;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import toolbar.item.Item;

public class Item2D
extends Item {
    private ImageIcon icon;
    private AbstractAction action;
    private boolean mouseOver = false;
    private static final transient Color selectColor = new Color(0, 0, 0);
    private static final transient BasicStroke selectStroke = new BasicStroke(2.0f);

    public Item2D(ImageIcon icon, AbstractAction action, boolean removable) {
        this.action = action;
        this.icon = icon;
        this.removable = removable;
        this.setOpaque(false);
    }

    public Dimension getPreferredSize() {
        this.preferredSize.width = (int)Math.ceil((double)this.baseDimension.width * this.ratio);
        this.preferredSize.height = (int)Math.ceil((double)this.baseDimension.height * this.ratio);
        return this.preferredSize;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.icon.getImage(), this.position.x, this.position.y, (int)((double)this.baseDimension.width * this.ratio), (int)((double)this.baseDimension.height * this.ratio), this);
        if (this.mouseOver) {
            g2.setColor(selectColor);
            g2.setStroke(selectStroke);
            g2.drawRoundRect(this.position.x, this.position.y, (int)((double)this.baseDimension.width * this.ratio), (int)((double)this.baseDimension.height * this.ratio), 10, 10);
        }
    }

    public AbstractAction getAction() {
        return this.action;
    }

    public void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }
}

