/*
 * Decompiled with CFR 0.152.
 */
package toolbar;

import action.ActionRemoveItem;
import action.ActionRunWinProg;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import sun.awt.shell.ShellFolder;
import toolbar.item.Indicator;
import toolbar.item.Item;
import toolbar.item.Item2D;
import toolbar.listener.ToolbarListener;
import toolbar.save.ToolbarPersister;

public class JToolBarPanel
extends JPanel
implements Runnable {
    private Vector<Item> lstItem;
    private final Insets insets = new Insets(2, 5, 2, 5);
    private int windowsSize = 0;
    private int windowsHeight = 0;
    private int windowsWidth = 0;
    private int barSize = 0;
    private int translation = 0;
    private int lasttranslation = 0;
    private int lastmousepos = 0;
    private boolean mouseOnPanel = false;
    private Dimension preferredSize = new Dimension(0, 0);
    private int normalIconSize;
    private final double NORMAL_RATIO = 1.0;
    private double MAX_RATIO = 1.5;
    private final int NORMAL_RATIO_DIST = 100;
    private final int MAX_RATIO_DIST = 2;
    private final int WAIT_TIME = 10;
    private final int STOP_ZONE = 60;
    private final int SPEED_REDUCTION = 40;
    public static final int WEST = 1;
    public static final int EAST = 2;
    public static final int NORTH = 3;
    public static final int SOUTH = 4;
    private int orientation = 3;
    private Indicator dndindic = null;
    private Item2D lastItemUnder = null;
    private boolean lastPlaceDropping = false;
    private final int INDIC_SIZE = 2;
    private ToolbarListener tbl = new ToolbarListener(this);
    private ToolbarPersister tp = null;

    public JToolBarPanel(int normalIconSize, String folderName) {
        this.initAndStart(normalIconSize, folderName);
    }

    public JToolBarPanel(int normalIconSize, int maxIconSize, String folderName) {
        this.MAX_RATIO = (double)maxIconSize / (double)normalIconSize;
        this.initAndStart(normalIconSize, folderName);
    }

    private void initAndStart(int normalIconSize, String folderName) {
        this.normalIconSize = normalIconSize;
        this.setLayout(null);
        this.addMouseMotionListener(this.tbl);
        this.addMouseListener(this.tbl);
        this.setOpaque(true);
        this.dndindic = new Indicator(2, (int)((double)normalIconSize * this.MAX_RATIO));
        if (folderName != null) {
            this.tp = new ToolbarPersister(folderName);
            this.lstItem = this.tp.load();
        } else {
            this.lstItem = new Vector();
        }
        new Thread(this).start();
    }

    public void addItem(Item item) {
        item.setRatio(1.0);
        this.lstItem.add(item);
        this.resizeAndPlaceItem(true);
        this.repaint();
        if (this.tp != null) {
            this.tp.save(this.lstItem);
        }
    }

    public void addItem(Item item, int index) {
        item.setRatio(1.0);
        this.lstItem.add(index, item);
        this.resizeAndPlaceItem(true);
        this.repaint();
        if (this.tp != null) {
            this.tp.save(this.lstItem);
        }
    }

    public boolean removeItem(Item item) {
        if (item.isRemovable()) {
            int pos = this.lstItem.indexOf(item);
            if (pos == this.lstItem.size() - 1) {
                this.lstItem.get(this.lstItem.size() - 2).setRatio(this.MAX_RATIO);
            }
            boolean removeOK = this.lstItem.remove(item);
            this.resizeAndPlaceItem(true);
            this.repaint();
            if (this.tp != null) {
                this.tp.save(this.lstItem);
            }
            return removeOK;
        }
        return false;
    }

    public void removeItem(int index) {
        if (this.lstItem.get(index).isRemovable()) {
            if (index == this.lstItem.size() - 1) {
                this.lstItem.get(this.lstItem.size() - 2).setRatio(this.MAX_RATIO);
            }
            this.lstItem.remove(index);
            this.resizeAndPlaceItem(true);
            this.repaint();
            if (this.tp != null) {
                this.tp.save(this.lstItem);
            }
        }
    }

    public void removeAllItem() {
        this.lstItem.removeAllElements();
        if (this.tp != null) {
            this.tp.save(this.lstItem);
        }
    }

    private void init() {
        int pos = this.insets.left;
        this.windowsHeight = 0;
        this.windowsWidth = 0;
        this.barSize = this.insets.left;
        if (!this.lstItem.isEmpty()) {
            for (Item item : this.lstItem) {
                pos += this.insets.left;
                if (this.orientation == 3 || this.orientation == 4) {
                    item.getPosition().x = pos;
                    item.getPosition().y = this.insets.top;
                    item.getBasePosition().x = pos;
                    item.getBasePosition().y = this.insets.top;
                    pos += item.getPreferredSize().width + this.insets.right;
                    this.barSize += this.insets.left + item.getPreferredSize().width + this.insets.right;
                    continue;
                }
                item.getPosition().x = this.insets.top;
                item.getPosition().y = pos;
                item.getBasePosition().x = this.insets.top;
                item.getBasePosition().y = pos;
                pos += item.getPreferredSize().height + this.insets.right;
                this.barSize += this.insets.left + item.getPreferredSize().height + this.insets.right;
            }
            this.barSize += this.insets.right;
            double lastItemSize = 0.0;
            if (this.orientation == 3 || this.orientation == 4) {
                lastItemSize = this.lstItem.get((int)(this.lstItem.size() - 1)).getBaseDimension().width;
                this.windowsHeight = (int)((double)this.insets.top + lastItemSize * this.MAX_RATIO + (double)this.insets.bottom);
            } else {
                lastItemSize = this.lstItem.get((int)(this.lstItem.size() - 1)).getBaseDimension().height;
                this.windowsWidth = (int)((double)this.insets.top + lastItemSize * this.MAX_RATIO + (double)this.insets.bottom);
            }
            this.barSize = (int)((double)this.barSize + lastItemSize * 1.0 / 2.0);
        }
    }

    private void resizeAndPlaceItem(boolean forceReplacement) {
        int mousediff = this.windowsSize / 2 - this.tbl.getMousepos();
        if (this.windowsSize < this.barSize) {
            if (Math.abs(mousediff) > 30) {
                this.translation += mousediff / 40;
                if (this.translation > 0) {
                    this.translation = 0;
                }
                if (this.translation < -(this.barSize - this.windowsSize)) {
                    this.translation = -(this.barSize - this.windowsSize);
                }
            }
        } else {
            this.translation = 0;
        }
        int i = 0;
        while (i < this.lstItem.size()) {
            this.setRatio(this.lstItem.get(i), i == 0, i == this.lstItem.size() - 1);
            ++i;
        }
        if (this.lastmousepos != this.tbl.getMousepos() || this.lasttranslation != this.translation || forceReplacement) {
            int pos = this.insets.left;
            int offset = 0;
            for (Item item : this.lstItem) {
                pos += this.insets.left;
                if (this.orientation == 3 || this.orientation == 4) {
                    offset = this.orientation == 4 ? this.windowsHeight - item.getPreferredSize().height - this.insets.bottom * 2 : 0;
                    item.getPosition().x = pos;
                    item.getPosition().y = this.insets.top + offset;
                    pos += item.getPreferredSize().height + this.insets.right;
                } else {
                    offset = this.orientation == 2 ? this.windowsWidth - item.getPreferredSize().width - this.insets.bottom * 2 : 0;
                    item.getPosition().x = this.insets.top + offset;
                    item.getPosition().y = pos;
                    pos += item.getPreferredSize().height + this.insets.right;
                }
                if (!(item instanceof Item2D)) continue;
                ((Item2D)item).setMouseOver(this.tbl.isDndRunning() ? false : this.mouseOver(item, this.tbl.getMouseOverPoint()));
            }
            if (this.tbl.isDndRunning()) {
                this.replaceDNDIndicator();
            }
            this.lastmousepos = this.tbl.getMousepos();
            this.lasttranslation = this.translation;
        }
    }

    private void replaceDNDIndicator() {
        Item2D item = this.getItemUnderTheMouse(this.tbl.getMouseOverPoint());
        this.lastPlaceDropping = false;
        if (item == null) {
            item = this.lastItemUnder;
        }
        if (item != null) {
            if (this.orientation == 3 || this.orientation == 4) {
                if (this.tbl.getMouseOverPoint().x - item.getPosition().x - this.translation > item.getPreferredSize().width / 2) {
                    if (this.lstItem.indexOf(item) == this.lstItem.size() - 1) {
                        this.dndindic.getPosition().x = item.getPosition().x + this.insets.right + item.getPreferredSize().width;
                        this.lastPlaceDropping = true;
                    } else {
                        item = (Item2D)this.lstItem.get(this.lstItem.indexOf(item) + 1);
                        this.dndindic.getPosition().x = item.getPosition().x - this.insets.right - 1;
                    }
                } else {
                    this.dndindic.getPosition().x = item.getPosition().x - this.insets.right - 1;
                }
                this.dndindic.getPosition().y = item.getPosition().y;
            } else {
                if (this.tbl.getMouseOverPoint().y - item.getPosition().y - this.translation > item.getPreferredSize().height / 2) {
                    if (this.lstItem.indexOf(item) == this.lstItem.size() - 1) {
                        this.dndindic.getPosition().y = item.getPosition().y + this.insets.right + item.getPreferredSize().height;
                        this.lastPlaceDropping = true;
                    } else {
                        item = (Item2D)this.lstItem.get(this.lstItem.indexOf(item) + 1);
                        this.dndindic.getPosition().y = item.getPosition().y - this.insets.right - 1;
                    }
                } else {
                    this.dndindic.getPosition().y = item.getPosition().y - this.insets.right - 1;
                }
                this.dndindic.getPosition().x = item.getPosition().x;
            }
            this.lastItemUnder = item;
        }
    }

    private void clean() {
        this.init();
        this.resizeAndPlaceItem(false);
        this.translation = -(this.barSize - this.windowsSize) / 2;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.orientation == 3 || this.orientation == 4) {
            this.preferredSize.width = this.windowsSize;
            this.preferredSize.height = this.windowsHeight;
        } else {
            this.preferredSize.width = this.windowsWidth;
            this.preferredSize.height = this.windowsSize;
        }
        return this.preferredSize;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.orientation == 3 || this.orientation == 4) {
            g2.translate(this.translation, 0);
        } else {
            g2.translate(0, this.translation);
        }
        for (Item item : this.lstItem) {
            item.paintComponent(g2);
        }
        if (this.tbl.isDndRunning()) {
            this.dndindic.paintComponent(g2);
        }
    }

    public boolean mouseOver(Item item, Point position) {
        if (this.orientation == 3 || this.orientation == 4) {
            return position.x > item.getPosition().x + this.translation && position.x < item.getPosition().x + item.getPreferredSize().width + this.translation && position.y > item.getPosition().y && position.y < item.getPosition().y + item.getPreferredSize().height;
        }
        return position.x > item.getPosition().x && position.x < item.getPosition().x + item.getPreferredSize().width && position.y > item.getPosition().y + this.translation && position.y < item.getPosition().y + item.getPreferredSize().height + this.translation;
    }

    public Item2D getItemUnderTheMouse(Point pos) {
        for (Item item : this.lstItem) {
            if (!this.mouseOver(item, pos) || !(item instanceof Item2D)) continue;
            return (Item2D)item;
        }
        return null;
    }

    private void setRatio(Item item, boolean fisrt, boolean last) {
        int distFromMouse = 0;
        distFromMouse = this.orientation == 3 || this.orientation == 4 ? item.getBasePosition().x + (int)(item.getBaseDimension().getWidth() * 1.0 / 2.0) + this.translation - this.tbl.getMousepos() : item.getBasePosition().y + (int)(item.getBaseDimension().getHeight() * 1.0 / 2.0) + this.translation - this.tbl.getMousepos();
        int absDistFromMouse = Math.abs(distFromMouse);
        if (fisrt && distFromMouse > 0 || last && distFromMouse < 0) {
            item.setRatio(this.MAX_RATIO);
            return;
        }
        if (absDistFromMouse >= 100) {
            item.setRatio(1.0);
        } else if (absDistFromMouse <= 2) {
            item.setRatio(this.MAX_RATIO);
        } else {
            double a = (1.0 - this.MAX_RATIO) / 98.0;
            double ratio = a * (double)absDistFromMouse + this.MAX_RATIO;
            if (ratio > this.MAX_RATIO) {
                ratio = this.MAX_RATIO;
            }
            if (ratio < 1.0) {
                ratio = 1.0;
            }
            item.setRatio(ratio);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.dndindic.setOrientation(orientation == 3 || orientation == 4 ? 1 : 0);
        this.init();
        this.resizeAndPlaceItem(true);
    }

    public void setWindowsSize(int windowsSize) {
        this.windowsSize = windowsSize;
        this.init();
        this.resizeAndPlaceItem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    this.resizeAndPlaceItem(false);
                    this.repaint();
                    Thread.sleep(10L);
                    if (this.mouseOnPanel) continue;
                    var1_1 = this;
                    synchronized (var1_1) {
                        this.wait();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterTheToolbar() {
        this.mouseOnPanel = true;
        JToolBarPanel jToolBarPanel = this;
        synchronized (jToolBarPanel) {
            this.notify();
        }
    }

    public void exitTheToolbar() {
        this.mouseOnPanel = false;
        for (Item item : this.lstItem) {
            if (!(item instanceof Item2D)) continue;
            ((Item2D)item).setMouseOver(false);
        }
        this.repaint();
    }

    public void rightClick(Point p) {
        Item2D item = this.getItemUnderTheMouse(p);
        if (item != null && item.isRemovable()) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new ActionRemoveItem(this, item));
            menu.show(this, p.x, p.y);
        }
    }

    public void leftClick(Point p) {
        Item2D item = this.getItemUnderTheMouse(p);
        if (item != null) {
            item.getAction().actionPerformed(null);
        }
    }

    public void dndAdd(File file) throws FileNotFoundException {
        ShellFolder shellFolder = ShellFolder.getShellFolder(file);
        ImageIcon icon = new ImageIcon(shellFolder.getIcon(true));
        Item2D item = new Item2D(icon, new ActionRunWinProg("Test", "rundll32 SHELL32.DLL,ShellExec_RunDLL " + file.getAbsolutePath()), true);
        item.getBaseDimension().width = this.normalIconSize;
        item.getBaseDimension().height = this.normalIconSize;
        if (this.lastPlaceDropping) {
            this.addItem(item);
        } else {
            this.addItem(item, this.lstItem.indexOf(this.lastItemUnder));
        }
    }

    public void dndMove(Item2D item) {
        this.lstItem.remove(item);
        if (this.lastPlaceDropping) {
            this.addItem(item);
        } else {
            this.addItem(item, this.lstItem.indexOf(this.lastItemUnder));
        }
    }
}

