/*
 * Decompiled with CFR 0.152.
 */
package toolbar;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import toolbar.JToolBarPanel;
import toolbar.item.Item;

public class DynamicToolBar
extends JToolBar
implements ComponentListener,
PropertyChangeListener {
    private JToolBarPanel toolbar;
    private Point ancestorPos = new Point(0, 0);
    private Border borderH;
    private Border borderV;
    private final int normalIconSize;

    public DynamicToolBar() {
        this.normalIconSize = 60;
        this.toolbar = new JToolBarPanel(this.normalIconSize, null);
        this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, new ImageIcon("./icone/default/tbh.png"));
        this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, new ImageIcon("./icone/default/tbv.png"));
        this.init();
    }

    public DynamicToolBar(String folderName) {
        this.normalIconSize = 60;
        this.toolbar = new JToolBarPanel(this.normalIconSize, folderName);
        this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, new ImageIcon("./icone/default/tbh.png"));
        this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, new ImageIcon("./icone/default/tbv.png"));
        this.init();
    }

    public DynamicToolBar(int normalIconSize, int maxIconSize, ImageIcon borderIconH, ImageIcon borderIconV) {
        this.normalIconSize = normalIconSize;
        this.toolbar = new JToolBarPanel(normalIconSize, maxIconSize, null);
        this.borderH = BorderFactory.createMatteBorder(0, borderIconH.getIconWidth(), 0, 0, borderIconH);
        this.borderV = BorderFactory.createMatteBorder(borderIconV.getIconHeight(), 0, 0, 0, borderIconV);
        this.init();
    }

    public DynamicToolBar(int normalIconSize, int maxIconSize, ImageIcon borderIconH, ImageIcon borderIconV, String folderName) {
        this.normalIconSize = normalIconSize;
        this.toolbar = new JToolBarPanel(normalIconSize, maxIconSize, folderName);
        this.borderH = BorderFactory.createMatteBorder(0, borderIconH.getIconWidth(), 0, 0, borderIconH);
        this.borderV = BorderFactory.createMatteBorder(borderIconV.getIconHeight(), 0, 0, 0, borderIconV);
        this.init();
    }

    private void init() {
        this.setBorder(this.borderH);
        this.addComponentListener(this);
        this.addPropertyChangeListener(this);
        this.add(this.toolbar);
    }

    public void addItem2D(Item item) {
        item.getBaseDimension().width = this.normalIconSize;
        item.getBaseDimension().height = this.normalIconSize;
        this.toolbar.addItem(item);
    }

    public boolean removeItem2D(Item item) {
        return this.toolbar.removeItem(item);
    }

    public void removeItem(int index) {
        this.toolbar.removeItem(index);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.toolbar != null) {
            this.toolbar.setBackground(bg);
        }
    }

    private void changeToolBarOrientation() {
        if (this.getOrientation() == 0) {
            this.toolbar.setOrientation(this.ancestorPos.y == 0 ? 3 : 4);
            this.setBorder(this.borderH);
        }
        if (this.getOrientation() == 1) {
            this.toolbar.setOrientation(this.ancestorPos.x == 0 ? 1 : 2);
            this.setBorder(this.borderV);
        }
        this.toolbar.repaint();
    }

    public void removeAll() {
        this.toolbar.removeAllItem();
    }

    public void componentMoved(ComponentEvent e) {
        this.ancestorPos.x = e.getComponent().getX();
        this.ancestorPos.y = e.getComponent().getY();
        this.changeToolBarOrientation();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ancestor")) {
            this.changeToolBarOrientation();
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.getOrientation() == 0) {
            this.toolbar.setWindowsSize(this.getWidth() - 10);
        }
        if (this.getOrientation() == 1) {
            this.toolbar.setWindowsSize(this.getHeight() - 10);
        }
        this.toolbar.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }
}

