/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByte;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0212;

public class EUC_JP
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP() {
        super("EUC-JP", ExtendedCharsets.aliasesFor("EUC-JP"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof JIS_X_0208 || charset instanceof JIS_X_0212 || charset instanceof EUC_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        static final SingleByte.Decoder DEC0201 = (SingleByte.Decoder)new JIS_X_0201().newDecoder();
        static final DoubleByte.Decoder DEC0208 = (DoubleByte.Decoder)new JIS_X_0208().newDecoder();
        static final DoubleByte.Decoder DEC0212 = (DoubleByte.Decoder)new JIS_X_0212().newDecoder();
        private final SingleByte.Decoder dec0201;
        private final DoubleByte.Decoder dec0208;
        private final DoubleByte.Decoder dec0212;

        protected Decoder(Charset charset) {
            this(charset, 0.5f, 1.0f, DEC0201, DEC0208, DEC0212);
        }

        protected Decoder(Charset charset, float f, float f2, SingleByte.Decoder decoder, DoubleByte.Decoder decoder2, DoubleByte.Decoder decoder3) {
            super(charset, f, f2);
            this.dec0201 = decoder;
            this.dec0208 = decoder2;
            this.dec0212 = decoder3;
        }

        protected char decodeDouble(int n, int n2) {
            if (n == 142) {
                if (n2 < 128) {
                    return '\ufffd';
                }
                return this.dec0201.decode((byte)n2);
            }
            return this.dec0208.decodeDouble(n - 128, n2 - 128);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 65533;
            try {
                for (n = n <= n2 ? n : n2; n < n2; n += n7) {
                    n5 = byArray[n] & 0xFF;
                    n7 = 1;
                    if ((n5 & 0x80) == 0) {
                        n8 = (char)n5;
                    } else if (n5 == 143) {
                        if (n + 3 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n5 = byArray[n + 1] & 0xFF;
                        n6 = byArray[n + 2] & 0xFF;
                        n7 += 2;
                        if (this.dec0212 == null) {
                            CoderResult coderResult = CoderResult.unmappableForLength(n7);
                            return coderResult;
                        }
                        n8 = this.dec0212.decodeDouble(n5 - 128, n6 - 128);
                    } else {
                        if (n + 2 > n2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n6 = byArray[n + 1] & 0xFF;
                        ++n7;
                        n8 = this.decodeDouble(n5, n6);
                    }
                    if (n8 == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(n7);
                        return coderResult;
                    }
                    if (n3 + 1 > n4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = n8;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            char c = '\ufffd';
            try {
                while (byteBuffer.hasRemaining()) {
                    n2 = byteBuffer.get() & 0xFF;
                    n4 = 1;
                    if ((n2 & 0x80) == 0) {
                        c = (char)n2;
                    } else if (n2 == 143) {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n2 = byteBuffer.get() & 0xFF;
                        n3 = byteBuffer.get() & 0xFF;
                        n4 += 2;
                        if (this.dec0212 == null) {
                            CoderResult coderResult = CoderResult.unmappableForLength(n4);
                            return coderResult;
                        }
                        c = this.dec0212.decodeDouble(n2 - 128, n3 - 128);
                    } else {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        n3 = byteBuffer.get() & 0xFF;
                        ++n4;
                        c = this.decodeDouble(n2, n3);
                    }
                    if (c == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(n4);
                        return coderResult;
                    }
                    if (charBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    charBuffer.put(c);
                    n += n4;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }
    }

    static class Encoder
    extends CharsetEncoder {
        static final SingleByte.Encoder ENC0201 = (SingleByte.Encoder)new JIS_X_0201().newEncoder();
        static final DoubleByte.Encoder ENC0208 = (DoubleByte.Encoder)new JIS_X_0208().newEncoder();
        static final DoubleByte.Encoder ENC0212 = (DoubleByte.Encoder)new JIS_X_0212().newEncoder();
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private final SingleByte.Encoder enc0201;
        private final DoubleByte.Encoder enc0208;
        private final DoubleByte.Encoder enc0212;

        protected Encoder(Charset charset) {
            this(charset, 3.0f, 3.0f, ENC0201, ENC0208, ENC0212);
        }

        protected Encoder(Charset charset, float f, float f2, SingleByte.Encoder encoder, DoubleByte.Encoder encoder2, DoubleByte.Encoder encoder3) {
            super(charset, f, f2);
            this.enc0201 = encoder;
            this.enc0208 = encoder2;
            this.enc0212 = encoder3;
        }

        @Override
        public boolean canEncode(char c) {
            byte[] byArray = new byte[3];
            return this.encodeSingle(c, byArray) != 0 || this.encodeDouble(c) != 65533;
        }

        protected int encodeSingle(char c, byte[] byArray) {
            int n = this.enc0201.encode(c);
            if (n == 65533) {
                return 0;
            }
            if (n >= 0 && n < 128) {
                byArray[0] = (byte)n;
                return 1;
            }
            byArray[0] = -114;
            byArray[1] = (byte)n;
            return 2;
        }

        protected int encodeDouble(char c) {
            int n = this.enc0208.encodeChar(c);
            if (n != 65533) {
                return n + 32896;
            }
            if (this.enc0212 != null && (n = this.enc0212.encodeChar(c)) != 65533) {
                n += 0x8F8080;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            int n5 = 0;
            boolean bl = false;
            byte[] byArray2 = new byte[3];
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    int n6;
                    byte[] byArray3 = byArray2;
                    char c = cArray[n];
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, cArray, n, n2) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n5 = this.encodeSingle(c, byArray3);
                    if (n5 == 0) {
                        n6 = this.encodeDouble(c);
                        if (n6 != 65533) {
                            if ((n6 & 0xFF0000) == 0) {
                                byArray3[0] = (byte)((n6 & 0xFF00) >> 8);
                                byArray3[1] = (byte)(n6 & 0xFF);
                                n5 = 2;
                            } else {
                                byArray3[0] = -113;
                                byArray3[1] = (byte)((n6 & 0xFF00) >> 8);
                                byArray3[2] = (byte)(n6 & 0xFF);
                                n5 = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (n4 - n3 < n5) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n6 = 0; n6 < n5; ++n6) {
                        byArray[n3++] = byArray3[n6];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = 0;
            boolean bl = false;
            byte[] byArray = new byte[3];
            int n2 = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n3;
                    byte[] byArray2 = byArray;
                    char c = charBuffer.get();
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    n = this.encodeSingle(c, byArray2);
                    if (n == 0) {
                        n3 = this.encodeDouble(c);
                        if (n3 != 65533) {
                            if ((n3 & 0xFF0000) == 0) {
                                byArray2[0] = (byte)((n3 & 0xFF00) >> 8);
                                byArray2[1] = (byte)(n3 & 0xFF);
                                n = 2;
                            } else {
                                byArray2[0] = -113;
                                byArray2[1] = (byte)((n3 & 0xFF00) >> 8);
                                byArray2[2] = (byte)(n3 & 0xFF);
                                n = 3;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (byteBuffer.remaining() < n) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    for (n3 = 0; n3 < n; ++n3) {
                        byteBuffer.put(byArray2[n3]);
                    }
                    ++n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n2);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }
}

