/*
 * Decompiled with CFR 0.152.
 */
package toolbar.listener;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import toolbar.JToolBarPanel;
import toolbar.item.Item;
import toolbar.item.Item2D;

public class ToolbarListener
implements MouseListener,
MouseMotionListener,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    DragSource dragSource = DragSource.getDefaultDragSource();
    DropTarget dropTarget;
    JToolBarPanel jtbp;
    private boolean dndRunning = false;
    public Cursor curseur;
    private Point mouseOverPoint = new Point(0, 0);
    private int mousepos = 0;

    public ToolbarListener(JToolBarPanel jtbp) {
        this.jtbp = jtbp;
    }

    public void overTheToolbar(Point p) {
        this.mouseOverPoint = p;
        this.mousepos = this.jtbp.getOrientation() == 3 || this.jtbp.getOrientation() == 4 ? p.x : p.y;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.jtbp.leftClick(e.getPoint());
        } else if (e.getButton() == 3) {
            this.jtbp.rightClick(e.getPoint());
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.overTheToolbar(e.getPoint());
    }

    public void mouseEntered(MouseEvent e) {
        this.jtbp.enterTheToolbar();
    }

    public void mouseExited(MouseEvent e) {
        this.jtbp.exitTheToolbar();
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Item2D item = this.jtbp.getItemUnderTheMouse(this.mouseOverPoint);
        if (item == null) {
            return;
        }
        if (item == this.jtbp.getLogout()) {
            return;
        }
        dge.startDrag(DragSource.DefaultMoveDrop, item, this);
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable tr = dtde.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                for (Object o : fileList) {
                    this.jtbp.dndAdd((File)o);
                }
                dtde.getDropTargetContext().dropComplete(true);
                this.dndRunning = false;
            } else if (tr.isDataFlavorSupported(Item.ITEM_FORMAT)) {
                dtde.acceptDrop(2);
                Item2D item = (Item2D)tr.getTransferData(Item.ITEM_FORMAT);
                this.jtbp.dndMove(item);
                dtde.getDropTargetContext().dropComplete(true);
                this.dndRunning = false;
            } else {
                dtde.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dtde.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dtde.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.dndRunning = true;
        this.jtbp.enterTheToolbar();
    }

    public void dragExit(DropTargetEvent dte) {
        this.dndRunning = false;
        this.jtbp.exitTheToolbar();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.overTheToolbar(dtde.getLocation());
        if (!dtde.isDataFlavorSupported(Item.ITEM_FORMAT)) {
            this.curseur = DragSource.DefaultMoveNoDrop;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(this.curseur);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public boolean isDndRunning() {
        return this.dndRunning;
    }

    public int getMousepos() {
        return this.mousepos;
    }

    public Point getMouseOverPoint() {
        return this.mouseOverPoint;
    }

    public void reset() {
        this.mouseOverPoint = new Point(0, 0);
        this.mousepos = 0;
    }
}

