/*
 * Decompiled with CFR 0.152.
 */
package toolbar.item;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import toolbar.item.Item;
import toolbar.utils.ToolBarRenderer;

public class Item2D
extends Item {
    private ImageIcon icon;
    private AbstractAction action;
    private boolean mouseOver = false;
    private ToolBarRenderer tbr = null;

    public Item2D(ImageIcon icon, AbstractAction action, boolean removable) {
        this.action = action;
        this.icon = icon;
        this.removable = removable;
        this.setOpaque(false);
    }

    public Dimension getPreferredSize() {
        this.preferredSize.width = (int)Math.ceil((double)this.baseDimension.width * this.ratio);
        this.preferredSize.height = (int)Math.ceil((double)this.baseDimension.height * this.ratio);
        return this.preferredSize;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.icon.getImage(), this.position.x, this.position.y, this.preferredSize.width, this.preferredSize.height, this);
        if (this.mouseOver) {
            this.tbr.paintSelector(g2, this.position, this.preferredSize);
        }
    }

    public AbstractAction getAction() {
        return this.action;
    }

    public void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
    }

    public void setTbr(ToolBarRenderer tbr) {
        this.tbr = tbr;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.repaint();
    }
}

