/*
 * Decompiled with CFR 0.152.
 */
package toolbar;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import toolbar.JToolBarPanel;
import toolbar.item.Item;
import toolbar.item.Item2D;
import toolbar.utils.DefautToolbarRenderer;
import toolbar.utils.ToolBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicToolBar
extends JToolBar
implements ComponentListener,
PropertyChangeListener {
    private JToolBarPanel toolbar;
    private Point ancestorPos = new Point(0, 0);
    private Border borderH = null;
    private Border borderV = null;
    private final int normalIconSize;
    private ToolBarRenderer tbr = null;

    public DynamicToolBar() {
        this.tbr = new DefautToolbarRenderer();
        this.normalIconSize = this.tbr.normalIconSize();
        this.toolbar = new JToolBarPanel(null, this.tbr);
        if (this.tbr.showBorder()) {
            this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, this.tbr.borderIconH());
            this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, this.tbr.borderIconV());
        }
        this.init();
    }

    public DynamicToolBar(ToolBarRenderer tbr) {
        this.tbr = tbr;
        this.normalIconSize = tbr.normalIconSize();
        this.toolbar = new JToolBarPanel(null, tbr);
        if (tbr.showBorder()) {
            this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, tbr.borderIconH());
            this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, tbr.borderIconV());
        }
        this.init();
    }

    public DynamicToolBar(ToolBarRenderer tbr, ImageIcon log, AbstractAction actionLogout) {
        this.tbr = tbr;
        this.normalIconSize = tbr.normalIconSize();
        this.toolbar = new JToolBarPanel(null, tbr, log, actionLogout);
        if (tbr.showBorder()) {
            this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, tbr.borderIconH());
            this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, tbr.borderIconV());
        }
        this.init();
    }

    public DynamicToolBar(ToolBarRenderer tbr, String folderName) {
        this.tbr = tbr;
        this.normalIconSize = tbr.normalIconSize();
        this.toolbar = new JToolBarPanel(folderName, tbr);
        if (tbr.showBorder()) {
            this.borderH = BorderFactory.createMatteBorder(0, 15, 0, 0, tbr.borderIconH());
            this.borderV = BorderFactory.createMatteBorder(15, 0, 0, 0, tbr.borderIconV());
        }
        this.init();
    }

    private void init() {
        if (this.borderH != null) {
            this.setBorder(this.borderH);
        }
        this.addComponentListener(this);
        this.addPropertyChangeListener(this);
        this.add(this.toolbar);
    }

    public void addItem2D(Item2D item) {
        item.setTbr(this.tbr);
        item.getBaseDimension().width = this.normalIconSize;
        item.getBaseDimension().height = this.normalIconSize;
        this.toolbar.addItem(item);
    }

    public boolean removeItem2D(Item item) {
        return this.toolbar.removeItem(item);
    }

    public void removeItem(int index) {
        this.toolbar.removeItem(index);
    }

    public Item2D getItem2D(int i) {
        return (Item2D)this.toolbar.getItem(i);
    }

    public Vector<Item> getLstItem() {
        return this.toolbar.getLstItem();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.toolbar != null) {
            this.toolbar.setBackground(bg);
        }
    }

    private void changeToolBarOrientation() {
        if (this.getOrientation() == 0) {
            this.toolbar.setOrientation(this.ancestorPos.y == 0 ? 3 : 4);
            this.setBorder(this.borderH);
        }
        if (this.getOrientation() == 1) {
            this.toolbar.setOrientation(this.ancestorPos.x == 0 ? 1 : 2);
            this.setBorder(this.borderV);
        }
        this.toolbar.repaint();
    }

    public JToolBarPanel getToolbar() {
        return this.toolbar;
    }

    public Item2D getLogout() {
        return this.toolbar.getLogout();
    }

    @Override
    public void removeAll() {
        this.toolbar.removeAllItem();
        this.toolbar.setWindowsSize(this.getWidth() - 10);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.ancestorPos.x = e.getComponent().getX();
        this.ancestorPos.y = e.getComponent().getY();
        this.changeToolBarOrientation();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ancestor")) {
            this.changeToolBarOrientation();
        }
    }

    public void update() {
        this.toolbar.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.getOrientation() == 0) {
            this.toolbar.setWindowsSize(this.getWidth() - 10);
        }
        if (this.getOrientation() == 1) {
            this.toolbar.setWindowsSize(this.getHeight() - 10);
        }
        this.toolbar.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

